scriptName aaaUCPlayerAliasScript extends ReferenceAlias

Actor property player auto
GlobalVariable property aaaUCDraugrAI auto
Spell property aaaUCFalmerSpell auto
Spell property aaaUCStaggerControlSpell auto
GlobalVariable property aaaUCPerfectBlock auto
GlobalVariable property aaaUCPoiseBase auto
GlobalVariable property aaaUCSpeedBonus auto
Spell property aaaUCSlowWeaponSpell auto
Keyword property ActorTypeGiant auto
Spell property aaaUCDraugrSpell auto
Spell property aaaUCEnemySpell auto
Spell property aaaUCSkeletonSpell auto
Activator property FXEmptyActivator auto
Keyword property WeapTypeBow auto
GlobalVariable property aaaUCTimedBlockTime auto
GlobalVariable property aaaUCPoiseDamagePlayer auto
VoiceType property CrDragonPriestVoice auto
Race property SkeletonRace auto
GlobalVariable property aaaUCPoise auto
Spell property aaaUCGiantSpell auto
GlobalVariable property aaaUCSkeletonAI auto
Sound property aaaUCHitSound auto
GlobalVariable property aaaUCPerfectBlockStop auto
GlobalVariable property aaaUCGiantAI auto
ImageSpaceModifier property aaaUCPerfectBlockBlurImod auto
Spell property InfightingShieldSpell auto
Explosion property aaaUCLocDamageExplosion auto
Spell property aaaUCDragonPriestSpell auto
Keyword property ActorTypeAnimal auto
Keyword property ImmuneParalysis auto
Sound property aaaUCPerfectBlockImpactSM auto
Race property DwarvenCenturionRace auto
Keyword property ActorTypeDragon auto
GlobalVariable property aaaUCHeadshotMessage auto
Race property FalmerRace auto
GlobalVariable property aaaUCStaggerPlayer auto
GlobalVariable property aaaUCHeadshotSound auto
Race property DraugrRace auto
Keyword property UpdateDuringArchery auto
Spell property aaaUCPerfectBlockFXSpell auto
Keyword property ActorTypeNPC auto
Spell property StaggerSpell auto
Sound property aaaUCInfightingShieldSM auto
GlobalVariable property aaaUCStaggerBowNPC auto
GlobalVariable property aaaUCPerfectBlockBlur auto
GlobalVariable property aaaUCBlockNPCKillmove auto
GlobalVariable property aaaUCNPCAI auto
GlobalVariable property aaaUCFalmerAI auto
GlobalVariable property aaaUCHeadShotDamageMult auto
Spell property aaaUCSlowMoveSpell auto
Spell property aaaUCCenturionSpell auto
GlobalVariable property aaaUCCenturionAI auto
GlobalVariable property aaaUCDragonPriestAI auto
Perk property PlayerPerk auto

Spell property _MODaaaUCPerfectBlockLargeFXSpell auto
Spell property _MODaaaUCPerfectBlockAbLvl20 auto
;Impactdataset property BlockSparksTest auto
Explosion property _MODSparksExplosion auto
Explosion property _MODSparksBlockRing auto
Explosion property _MODSparksBlock auto
Activator property _MODxMarkerActivatorDeleteSelf auto
ObjectReference BlockFX

weapon weap
int weapType

bool IsBeast = false
bool IsHCStealth = false
float Poise
float DisableOnHitTime
float CritDmg
bool HCDamage = false

function BlockNPCKillmove(bool bPause) global native
bool function IsGamePaused() global native
function PauseGame(bool bPause) global native
bool function IsBlockNPCKillmove() global native

function Pause()

	if !aaaUCPlayerAliasScript.IsGamePaused()
		aaaUCPerfectBlockBlurImod.Apply(aaaUCPerfectBlockBlur.GetValue())
		aaaUCPlayerAliasScript.PauseGame(true)
		utility.WaitMenuMode(aaaUCPerfectBlockStop.GetValue())
		aaaUCPlayerAliasScript.PauseGame(false)
	endIf
	aaaUCPerfectBlock.SetValueInt(0)
	self.GotoState("")
endFunction

function RegisterPreHitFrame(bool On)

	if aaaUCSpeedBonus.GetValueInt() == 1 && On
		self.RegisterForAnimationEvent(player as objectreference, "PreHitFrame")
	elseIf self.RegisterForAnimationEvent(player as objectreference, "PreHitFrame") && On == false
		self.UnRegisterForAnimationEvent(player as objectreference, "PreHitFrame")
	endIf
endFunction

function UC_OnHitProjectile(objectreference akTarget, float x, float y, float z)

	if aaaUCHeadShotDamageMult.GetValue() == 0.000000
		return 
	endIf
	string[] sNode = new string[5]
	sNode[0] = "NPC R Calf [RClf]"
	sNode[1] = "NPC L Calf [LClf]"
	sNode[2] = "NPC R Forearm [RLar]"
	sNode[3] = "NPC L Forearm [LLar]"
	sNode[4] = "NPC Head [Head]"
	int i = sNode.length
	while i
		i -= 1
		if netimmerse.HasNode(akTarget, sNode[i], false)
			float diff = 18.0000
			float nodeX = netimmerse.GetNodePositionX(akTarget, sNode[i], false)
			float nodeY = netimmerse.GetNodePositionY(akTarget, sNode[i], false)
			float nodeZ = netimmerse.GetNodePositionZ(akTarget, sNode[i], false)
			if i == 4
				nodeZ += 10.0000
			endIf
			float diffX = x - nodeX
			float diffY = y - nodeY
			float diffZ = z - nodeZ
			float distance = diffX * diffX + diffY * diffY + diffZ * diffZ
			if distance < diff * diff
				objectreference Box = akTarget.placeatme(FXEmptyActivator as form, 1, false, false)
				Box.SetPosition(x, y, z)
				Box.placeatme(aaaUCLocDamageExplosion as form, 1, false, false)
				Box.Delete()
				Box = none
				if i == 4
					if aaaUCHeadshotMessage.GetValueInt() == 1
						debug.notification("Headshot")
					endIf
					if aaaUCHeadshotSound.GetValueInt() == 1
						aaaUCHitSound.play(akTarget)
					endIf
					armor WornHead = (akTarget as actor).GetWornForm(4096) as armor
					float HeadDef = 1 as float
					if WornHead
						HeadDef = 100 as float / (100 as float - WornHead.GetArmorRating() as float) + 0.100000
					endIf
					float Dmg = (player.GetAV("Marksman") * 0.200000 + aaaUCPoiseDamagePlayer.GetValue() / 4 as float) / HeadDef * aaaUCHeadShotDamageMult.GetValue()
					(akTarget as actor).DamageAV("Health", Dmg)
					return 
				elseIf i == 0 || i == 1
					aaaUCSlowMoveSpell.Cast(akTarget, none)
					return 
				elseIf i == 2 || i == 3
					aaaUCSlowWeaponSpell.Cast(akTarget, none)
					return 
				endIf
			endIf
		endIf
	endWhile
endFunction

function TimedBlockOn()

	self.RegisterForAnimationEvent(player as objectreference, "SoundPlay.NPCHumanCombatShieldBlock")
	self.RegisterForAnimationEvent(player as objectreference, "BeginCastRight")
	self.RegisterForAnimationEvent(player as objectreference, "BeginCastLeft")
	player.ForceAV("JumpingBonus", 1.00000)
endFunction

function HardCoreStealthOff()

	IsHCStealth = false
	game.SetGameSettingFloat("fSneakDistanceAttenuationExponent", 2.00000)
	game.SetGameSettingFloat("fSneakEquippedWeightMult", 0.500000)
	game.SetGameSettingFloat("fSneakLightMoveMult", 0.0100000)
	game.SetGameSettingFloat("fSneakLightMult", 0.330000)
	game.SetGameSettingFloat("fSneakLightRunMult", 0.200000)
	game.SetGameSettingFloat("fSneakAlertMod", 0.000000)
	game.SetGameSettingFloat("fSneakSoundsMult", 1.00000)
	game.SetGameSettingFloat("fCombatStealthPointRegenAlertWaitTime", 10 as float)
	game.SetGameSettingFloat("fCombatStealthPointRegenAttackedWaitTime", 15 as float)
	game.SetGameSettingFloat("fCombatStealthPointRegenDetectedEventWaitTime", 10 as float)
	game.SetGameSettingFloat("fCombatStealthPointRegenLostWaitTime", 10 as float)
	game.SetGameSettingFloat("fCombatStealthPointRegenMin", 5 as float)
endFunction

function OnRaceSwitchComplete()

	if player.HasKeyword(ImmuneParalysis)
		IsBeast = true
	else
		IsBeast = false
		if aaaUCTimedBlockTime.GetValue() != 0.000000
			self.TimedBlockOn()
		endIf
		self.RegisterPreHitFrame(true)
	endIf
endFunction

function HardCoreStealthOn()

	IsHCStealth = true
	game.SetGameSettingFloat("fSneakDistanceAttenuationExponent", 1.50000)
	game.SetGameSettingFloat("fSneakEquippedWeightMult", 0.700000)
	game.SetGameSettingFloat("fSneakLightMoveMult", 0.0500000)
	game.SetGameSettingFloat("fSneakLightMult", 0.500000)
	game.SetGameSettingFloat("fSneakLightRunMult", 0.250000)
	game.SetGameSettingFloat("fSneakAlertMod", 0.100000)
	game.SetGameSettingFloat("fSneakSoundsMult", 1.10000)
	game.SetGameSettingFloat("fCombatStealthPointRegenAlertWaitTime", 20 as float)
	game.SetGameSettingFloat("fCombatStealthPointRegenAttackedWaitTime", 90 as float)
	game.SetGameSettingFloat("fCombatStealthPointRegenDetectedEventWaitTime", 45 as float)
	game.SetGameSettingFloat("fCombatStealthPointRegenLostWaitTime", 30 as float)
	game.SetGameSettingFloat("fCombatStealthPointRegenMin", 2 as float)
endFunction

function HardCoreModeOff()

	HCDamage = false
	game.SetGameSettingFloat("fArmorScalingFactor", 0.120000)
	game.SetGameSettingFloat("fDamagePCSkillMin", 1.00000)
	game.SetGameSettingFloat("fDamagePCSkillMax", 1.50000)
	game.SetGameSettingFloat("fDamageSkillMin", 1.00000)
	game.SetGameSettingFloat("fDamageSkillMax", 3.00000)
	game.SetGameSettingFloat("fArmorRatingMax", 2.50000)
endFunction

function HardCoreModeOn()

	HCDamage = true
	game.SetGameSettingFloat("fArmorScalingFactor", 0.106000)
	game.SetGameSettingFloat("fDamagePCSkillMin", 1.70000)
	game.SetGameSettingFloat("fDamagePCSkillMax", 2.00000)
	game.SetGameSettingFloat("fDamageSkillMin", 2.00000)
	game.SetGameSettingFloat("fDamageSkillMax", 3.50000)
	game.SetGameSettingFloat("fArmorRatingMax", 2.40000)
endFunction

function BlockTimer(int type)

	aaaUCPerfectBlock.SetValueInt(type)
	self.GotoState("TimedBlockEnd")
endFunction

function PlayerStagger(float PoiseDamage)

	DisableOnHitTime = 0.50000
	aaaUCPoise.SetValue(aaaUCPoise.GetValue() - PoiseDamage)
	if aaaUCPoise.GetValue() <= 0.000000
		player.SetAnimationVariableFloat("StaggerMagnitude", PoiseDamage / 100 as float)
		debug.SendAnimationEvent(player as objectreference, "staggerStop")
		debug.SendAnimationEvent(player as objectreference, "staggerStart")
		utility.Wait(PoiseDamage / 100 as float)
		debug.SendAnimationEvent(player as objectreference, "staggerStop")
		aaaUCPoise.SetValue(aaaUCPoiseBase.GetValue())
	endIf
endFunction

function OnHit(objectreference akAggressor, form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)

	if akAggressor == none
		return 
	endIf
	weap = akSource as weapon
	if weap == none
		return 
	endIf
	;self.GotoState("Busy")
	weapType = weap.GetWeaponType()
	DisableOnHitTime = 0.000000
	if weapType != 7 && weapType != 9
		if(abHitBlocked == true)
			;player.PlayImpactEffect(BlockSparksTest, "WEAPON", 0, 0, 0, 128, false, false)
			;player.PlayImpactEffect(BlockSparksTest, "WEAPON", 0, 0, 0, 256, false, false)
			;player.PlayImpactEffect(BlockSparksTest, "WEAPON", 0, 0, 0, 512, false, false)
			BlockFX = Player.Placeatme(_MODxMarkerActivatorDeleteSelf)
			BlockFX.MoveToNode(Player, "WEAPON")
			BlockFX.Placeatme(_MODSparksExplosion)
		endif
		If aaaUCPerfectBlock.GetValueInt() == 1
			if (abHitBlocked == true)
				aaaUCPerfectBlockImpactSM.play(player as objectreference)
					if((akAggressor as actor).GetActorValue("Stamina") <= 25)
						BlockFX.Placeatme(_MODSparksBlock)
						BlockFX.Placeatme(_MODSparksBlockRing)
						;_MODaaaUCPerfectBlockLargeFXSpell.Cast(player as objectreference, none)
						StaggerSpell.Cast(akAggressor, none)
						(akAggressor as actor).DamageActorValue("Stamina", Player.GetActorValue("Block") * 2)
					else
						BlockFX.Placeatme(_MODSparksBlock)
						BlockFX.Placeatme(_MODSparksBlockRing)
						;aaaUCPerfectBlockFXSpell.Cast(player as objectreference, none)
						(akAggressor as actor).DamageActorValue("Stamina", Player.GetActorValue("Block") * 2)
					endif
				Game.AdvanceSkill("Block", 2*(akAggressor as actor).GetEquippedWeapon().GetBaseDamage())
				player.RestoreAV("Stamina", game.GetGameSettingFloat("fStaminaBlockBase")*4)
				self.Pause()
				return 
			endIf
		Elseif (Player.GetEquippedItemType(0) == 10)
			;Shield effects.
			BlockFX.MoveToNode(Player, "SHIELD")
			BlockFX.Placeatme(_MODSparksBlockRing)
			Debug.SendAnimationEvent(akAggressor, "recoilStart")
		Elseif aaaUCPerfectBlock.GetValueInt() == 2 && math.abs(player.GetHeadingAngle(akAggressor)) < 25.0000
			InfightingShieldSpell.Cast(player as objectreference, none)
			aaaUCInfightingShieldSM.play(player as objectreference)
			StaggerSpell.Cast(akAggressor, none)
			self.Pause()
			return 
		endIf
		if aaaUCStaggerPlayer.GetValueInt() == 1 && aaaUCPerfectBlock.GetValueInt() == 0
			if abPowerAttack && !IsBeast
				if weapType > 0
					self.PlayerStagger(weap.GetWeight() + weap.GetStagger() * 10 as float)
				else
					self.PlayerStagger((akAggressor as actor).GetAV("Mass") * 10 as float)
				endIf
			endIf
		endIf
	elseIf aaaUCStaggerBowNPC.GetValue() != 0.000000 && (weapType == 7 || weapType == 9)
		self.PlayerStagger((weap.GetWeight() + 1 as float) * aaaUCStaggerBowNPC.GetValue())
	endIf
	utility.Wait(DisableOnHitTime)
	self.GotoState("")
endFunction

function OnAnimationEvent(objectreference akSource, String asEventName)

	if asEventName == "SoundPlay.NPCHumanCombatShieldBlock" && player.GetAV("Stamina") >= 10.0000
		self.BlockTimer(1)
	elseIf (asEventName == "BeginCastRight" || asEventName == "BeginCastLeft") && player.GetAV("Magicka") >= 10.0000
		self.BlockTimer(2)
	endIf
	if asEventName == "PreHitFrame"
		self.GotoState("SpeedBonus")
	endIf
endFunction

function UC_OnCombat(actor akCaster, int aiCombatState)

	if aiCombatState == 1
		utility.Wait(utility.RandomFloat(0.000000, 1.00000))
		if akCaster.IsDead()
			return 
		endIf
		if akCaster.HasKeyword(ActorTypeNPC) && aaaUCNPCAI.GetValue() == 1 as float
			akCaster.Addspell(aaaUCEnemySpell, true)
			akCaster.addspell(_MODaaaUCPerfectBlockAbLvl20)
		elseIf akCaster.GetRace() == DraugrRace && aaaUCDraugrAI.GetValue() == 1 as float
			akCaster.Addspell(aaaUCDraugrSpell, true)
			akCaster.addspell(_MODaaaUCPerfectBlockAbLvl20)
		elseIf akCaster.GetRace() == FalmerRace && aaaUCFalmerAI.GetValue() == 1 as float
			akCaster.SetAnimationVariableBool("UCAddAnim", true)
			akCaster.Addspell(aaaUCFalmerSpell, true)
			akCaster.addspell(_MODaaaUCPerfectBlockAbLvl20)
		elseIf (akCaster.GetRace() == SkeletonRace || akCaster.HasKeyword(UpdateDuringArchery) && akCaster.GetRace() != DraugrRace) && aaaUCSkeletonAI.GetValue() == 1 as float
			akCaster.Addspell(aaaUCSkeletonSpell, true)
			akCaster.addspell(_MODaaaUCPerfectBlockAbLvl20)
		elseIf akCaster.HasKeyword(ActorTypeGiant) && aaaUCGiantAI.GetValue() == 1 as float
			akCaster.Addspell(aaaUCGiantSpell, true)
			return 
		elseIf akCaster.GetRace() == DwarvenCenturionRace && aaaUCCenturionAI.GetValue() == 1 as float
			akCaster.Addspell(aaaUCCenturionSpell, true)
			return 
		elseIf akCaster.GetVoiceType() == CrDragonPriestVoice && aaaUCDragonPriestAI.GetValue() == 1 as float
			akCaster.Addspell(aaaUCDragonPriestSpell, true)
		endIf
		if akCaster.GetAV("WaterWalking") == 1.00000 || akCaster.GetAV("Mass") <= 0.500000
			return 
		endIf
		if !akCaster.HasKeyword(ActorTypeDragon)
			akCaster.Addspell(aaaUCStaggerControlSpell, true)
		endIf
	endIf
endFunction

function TimedBlockOff()

	aaaUCPerfectBlock.SetValueInt(0)
	self.UnRegisterForAnimationEvent(player as objectreference, "SoundPlay.NPCHumanCombatShieldBlock")
	self.UnRegisterForAnimationEvent(player as objectreference, "BeginCastRight")
	self.UnRegisterForAnimationEvent(player as objectreference, "BeginCastLeft")
	player.ForceAV("JumpingBonus", 1.00000)
endFunction

function NPCKillmove(bool bToggle)

	aaaUCPlayerAliasScript.BlockNPCKillmove(bToggle)
endFunction

function SetUp()

	if player.HasPerk(PlayerPerk) == false
		player.AddPerk(PlayerPerk)
	endIf
	if aaaUCTimedBlockTime.GetValue() != 0.000000
		self.TimedBlockOn()
	endIf
	if HCDamage
		self.HardCoreModeOn()
	endIf
	if IsHCStealth
		self.HardCoreStealthOn()
	endIf
	if aaaUCBlockNPCKillmove.GetValueInt() == 1
		aaaUCPlayerAliasScript.BlockNPCKillmove(true)
	endIf
	self.RegisterPreHitFrame(true)
endFunction

function OnInit()

	self.SetUp()
endFunction

function OnPlayerLoadGame()

	self.SetUp()
endFunction

state timedblockend

	function OnBeginState()

		utility.Wait(aaaUCTimedBlockTime.GetValue())
		aaaUCPerfectBlock.SetValueInt(0)
		;utility.Wait(0.500000)
		;BlockDisAnimation()
		self.GotoState("")
	endFunction

	function BlockTimer(int type)

		aaaUCPerfectBlock.SetValueInt(0)
	endFunction
endState

state busy

	function OnAnimationEvent(objectreference akSource, String asEventName)

		; Empty function
	endFunction

	function OnHit(objectreference akAggressor, form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)

		; Empty function
	endFunction

	function OnObjectEquipped(form akBaseObject, objectreference akReference)

		; Empty function
	endFunction
endState

state speedbonus

	function OnBeginState()

		float NPCSpeed
		float dir = player.GetAnimationVariableFloat("Direction")
		float speed = player.GetAnimationVariableFloat("Speed") * 0.00100000
		if dir <= 0.625000 && dir >= 0.375000
			speed *= -1 as float
		endIf
		actor Enemy = game.GetCurrentCrosshairRef() as actor
		if Enemy != none
			float dirE = Enemy.GetAnimationVariableFloat("Direction")
			NPCSpeed = Enemy.GetAnimationVariableFloat("Speed") * 0.00100000
			if dirE <= 0.625000 && dirE >= 0.375000
				NPCSpeed *= -1 as float
			endIf
		else
			NPCSpeed = 0 as float
		endIf
		player.ForceAV("JumpingBonus", 1 as float + speed + NPCSpeed)
		utility.Wait(0.200000)
		player.ForceAV("JumpingBonus", 1.00000)
		self.GotoState("")
	endFunction

	function OnAnimationEvent(objectreference akSource, String asEventName)

		; Empty function
	endFunction
endState
